import { Message } from "@mail/core/common/message_model";
import { fields } from "@mail/core/common/record";

import { patch } from "@web/core/utils/patch";

patch(Message.prototype, {
    setup() {
        super.setup(...arguments);
        this.rating_id = fields.One("rating.rating");
    },

    computeIsEmpty() {
        return super.computeIsEmpty() && !this.rating_id && !this.rating_value;
    },

    get removeParams() {
        return { ...super.removeParams, rating_value: false };
    },
});
