# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

from odoo import models


class StockRule(models.Model):
    _inherit = 'stock.rule'

    def _prepare_mo_vals(self, product_id, product_qty, product_uom, location_id, name, origin, company_id, values, bom):
        res = super()._prepare_mo_vals(product_id, product_qty, product_uom, location_id, name, origin, company_id, values, bom)
        if not bom.analytic_distribution:
            if values.get('analytic_distribution'):
                res['analytic_distribution'] = values.get('analytic_distribution')
            elif values.get('analytic_account_id'):
                res['analytic_distribution'] = {values.get('analytic_account_id').id: 100}
        return res
