{
    'name': 'Nano Theme',
    'description': 'Nano Theme - Responsive Bootstrap Theme for Odoo CMS',
    'category': 'Theme/Lifestyle',
    'summary': 'Maker, Agencies, Creative, Design, IT, Services, Fancy',
    'sequence': 270,
    'version': '2.0.0',
    'depends': ['theme_common'],
    'data': [
        'data/generate_primary_template.xml',
        'data/ir_asset.xml',
        'views/images_library.xml',

        'views/snippets/s_framed_intro.xml',
        'views/snippets/s_carousel_intro.xml',
        'views/snippets/s_cta_box.xml',
        'views/snippets/s_banner.xml',
        'views/snippets/s_carousel.xml',
        'views/snippets/s_comparisons_horizontal.xml',
        'views/snippets/s_cover.xml',
        'views/snippets/s_motto.xml',
        'views/snippets/s_card_offset.xml',
        'views/snippets/s_features.xml',
        'views/snippets/s_image_text.xml',
        'views/snippets/s_freegrid.xml',
        'views/snippets/s_images_wall.xml',
        'views/snippets/s_key_images.xml',
        'views/snippets/s_parallax.xml',
        'views/snippets/s_pricelist_boxed.xml',
        'views/snippets/s_references.xml',
        'views/snippets/s_references_social.xml',
        'views/snippets/s_references_grid.xml',
        'views/snippets/s_text_block.xml',
        'views/snippets/s_text_image.xml',
        'views/snippets/s_three_columns.xml',
        'views/snippets/s_company_team_grid.xml',
        'views/snippets/s_unveil.xml',
        'views/snippets/s_quadrant.xml',
        'views/snippets/s_quotes_carousel_compact.xml',
        'views/snippets/s_numbers_showcase.xml',
        'views/snippets/s_key_benefits.xml',
        'views/snippets/s_striped_center_top.xml',
        'views/snippets/s_tabs_images.xml',
        'views/snippets/s_big_number.xml',
        'views/snippets/s_image_frame.xml',
        'views/snippets/s_shape_image.xml',
        'views/snippets/s_text_cover.xml',
        'views/snippets/s_timeline_images.xml',
        'views/snippets/s_empowerment.xml',
        'views/snippets/s_discovery.xml',
        'views/snippets/s_attributes_horizontal.xml',
        'views/snippets/s_attributes_vertical.xml',
        'views/snippets/s_numbers.xml',
        'views/snippets/s_image_text_overlap.xml',
        'views/snippets/s_company_team_basic.xml',
        'views/snippets/s_cta_mobile.xml',
        'views/snippets/s_company_team_spotlight.xml',
        'views/snippets/s_website_form_cover.xml',
        'views/snippets/s_company_team_card.xml',
        'views/snippets/s_split_intro.xml',
        'views/snippets/s_form_aside.xml',
        'views/snippets/s_numbers_framed.xml',
        'views/new_page_template.xml',
    ],
    'images': [
        'static/description/nano_cover.gif',
        'static/description/nano_screenshot.webp',
    ],
    'images_preview_theme': {
        'website.s_cover_default_image': '/theme_nano/static/src/img/snippets/s_cover.webp',
        'website.library_image_10': '/theme_nano/static/src/img/snippets/s_images_wall_01.webp',
        'website.library_image_05': '/theme_nano/static/src/img/snippets/s_images_wall_02.webp',
        'website.library_image_08': '/theme_nano/static/src/img/snippets/s_images_wall_03.webp',
        'website.library_image_13': '/theme_nano/static/src/img/snippets/s_images_wall_04.webp',
        'website.library_image_03': '/theme_nano/static/src/img/snippets/s_images_wall_05.webp',
        'website.library_image_02': '/theme_nano/static/src/img/snippets/s_images_wall_06.webp',
        'website.s_parallax_default_image': '/theme_nano/static/src/img/snippets/s_parallax.webp',
        'website.s_picture_default_image': '/theme_nano/static/src/img/snippets/s_picture.webp',
        'website.s_reference_demo_image_1': '/theme_nano/static/src/img/snippets/s_reference_01.png',
        'website.s_reference_demo_image_2': '/theme_nano/static/src/img/snippets/s_reference_02.png',
        'website.s_reference_demo_image_3': '/theme_nano/static/src/img/snippets/s_reference_03.png',
        'website.s_reference_demo_image_4': '/theme_nano/static/src/img/snippets/s_reference_04.png',
        'website.s_reference_demo_image_5': '/theme_nano/static/src/img/snippets/s_reference_05.png',
        'website.s_reference_default_image_6': '/theme_nano/static/src/img/snippets/s_reference_06.png',
    },
    'configurator_snippets': {
        'homepage': ['s_discovery', 's_parallax', 's_text_block', 's_key_images', 's_image_text_overlap', 's_company_team_basic', 's_references', 's_numbers', 's_cta_box'],
    },
    'configurator_snippets_addons': {
        'website_sale': {
            'homepage': [
                ('website_sale.s_dynamic_snippet_category_list', 'after', 's_key_images'),
            ],
        },
    },
    'theme_customizations': {
        'website_sale.s_dynamic_snippet_category_list': {
            'data_attributes': {
                'rounded': '4',
                'gap': '4',
                'alignment': 'left',
            },
            'background': {
                'color': 'o_cc5',
            },
            'add_classes': [
                'pt88', 'pb112'
            ],
            'remove_classes': [
                'pt64', 'pb64', 's_dynamic_category_no_arrows',
            ],
        },
    },
    'new_page_templates': {
        'about': {
            'personal': ['s_text_cover', 's_image_text', 's_text_block_h2', 's_numbers', 's_features', 's_call_to_action'],
        },
        'landing': {
            '1': ['s_banner', 's_features', 's_masonry_block_default_template', 's_call_to_action', 's_references', 's_quotes_carousel'],
            '2': ['s_cover', 's_text_image', 's_text_block_h2', 's_three_columns_landing_1', 's_call_to_action'],
            '3': ['s_text_cover', 's_text_block_h2', 's_three_columns', 's_showcase', 's_color_blocks_2', 's_quotes_carousel', 's_call_to_action'],
        },
        'services': {
            '2': ['s_text_cover', 's_image_text', 's_text_image', 's_image_text_2nd', 's_call_to_action'],
        },
    },
    'author': 'Odoo S.A.',
    'license': 'LGPL-3',
    'assets': {
        'website.assets_editor': [
            'theme_nano/static/src/js/tour.js',
        ],
    }
}
