import { registry } from "@web/core/registry";
import { BooleanField } from "@web/views/fields/boolean/boolean_field";
import { SelectionField } from "@web/views/fields/selection/selection_field";
import { standardFieldProps } from "@web/views/fields/standard_field_props";

import { ResUserGroupIdsPopover } from "./res_user_group_ids_popover";

import { Component } from "@odoo/owl";
import { usePopover } from "@web/core/popover/popover_hook";

/**
 * /!\ This widget is not meant to be used anywhere else than inside form view
 * dynamically generated by the res_user_group_ids widget.
 */

class ResUserGroupIdsPrivilegeField extends Component {
    static template = "web.ResUserGroupIdsPrivilegeField";
    static components = { BooleanField, SelectionField };
    static props = { ...standardFieldProps };

    setup() {
        this.isDebug = odoo.debug;
        this.popover = usePopover(ResUserGroupIdsPopover);
        this.groups = this.env.resUserGroupsInfo.groups;
    }

    get disjointGroupIds() {
        const group = this.group || this.impliedGroup;
        return group ? group.disjointIds : [];
    }

    get group() {
        const groups = this.groups;
        return groups[this.findGroupId((gid) => groups[gid].selected)] || false;
    }

    get impliedGroup() {
        const groups = this.groups;
        return groups[this.findGroupId((gid) => groups[gid].impliedByIds.length > 0)] || false;
    }

    get impliedGroupDisplayName() {
        return !this.isSet && this.impliedGroup ? this.groups[this.impliedGroup.id].name : "";
    }

    get infoButtonClassnames() {
        const invisible = !this.isSet && !this.impliedGroup?.id;
        const isDisjoint = this.isDisjoint;
        return {
            o_group_info_button: true,
            invisible,
            btn: true,
            "btn-link": true,
            "py-0": true,
            fa: true,
            "fa-info-circle": !isDisjoint,
            "fa-exclamation-triangle": isDisjoint,
            "link-danger": isDisjoint,
        };
    }

    get isDisjoint() {
        return this.disjointGroupIds.length > 0;
    }

    get isImplied() {
        return !this.isSet && !!this.impliedGroup;
    }

    get isSet() {
        return !!this.props.record.data[this.props.name];
    }

    get type() {
        return this.props.record.fields[this.props.name].type;
    }

    findGroupId(predicate) {
        if (this.type === "selection") {
            const options = this.props.record.fields[this.props.name].selection;
            const option = options.findLast((o) => o[0] && predicate(o[0]));
            return option ? option[0] : false;
        } else {
            const groupId = this.env.resUserGroupsInfo.booleanFieldToGroupId[this.props.name];
            return predicate(groupId) ? groupId : false;
        }
    }

    onClickInfoButton(ev) {
        if (this.popover.isOpen) {
            this.popover.close();
        } else {
            this.popover.open(ev.currentTarget, {
                groupId: this.group ? this.group.id : this.impliedGroup.id,
                groups: this.env.resUserGroupsInfo.groups,
                privileges: this.env.resUserGroupsInfo.privileges,
            });
        }
    }
}

const resUserGroupIdsPrivilegeField = {
    component: ResUserGroupIdsPrivilegeField,
};

registry.category("fields").add("res_user_group_ids_privilege", resUserGroupIdsPrivilegeField);
