# Part of Odoo. See LICENSE file for full copyright and licensing details.

from odoo.tools.translate import LazyTranslate


_lt = LazyTranslate(__name__, default_lang='en_US')

# The keys that are sensitive and should not be logged.
SENSITIVE_KEYS = set()

# Mapping of ISO 3166-1 country codes in alpha-2 format to the numeric format.
COUNTRY_NUMERIC_CODES = {
    'AF': '004',
    'AL': '008',
    'DZ': '012',
    'AS': '016',
    'AD': '020',
    'AO': '024',
    'AG': '028',
    'AZ': '031',
    'AR': '032',
    'AU': '036',
    'AT': '040',
    'BS': '044',
    'BH': '048',
    'BD': '050',
    'AM': '051',
    'BB': '052',
    'BE': '056',
    'BM': '060',
    'BT': '064',
    'BO': '068',
    'BA': '070',
    'BW': '072',
    'BV': '074',
    'BR': '076',
    'BZ': '084',
    'IO': '086',
    'SB': '090',
    'VG': '092',
    'BN': '096',
    'BG': '100',
    'MM': '104',
    'BI': '108',
    'BY': '112',
    'KH': '116',
    'CM': '120',
    'CA': '124',
    'CV': '132',
    'KY': '136',
    'CF': '140',
    'LK': '144',
    'TD': '148',
    'CL': '152',
    'CN': '156',
    'TW': '158',
    'CX': '162',
    'CC': '166',
    'CO': '170',
    'KM': '174',
    'YT': '175',
    'CG': '178',
    'CD': '180',
    'CK': '184',
    'CR': '188',
    'HR': '191',
    'CU': '192',
    'CY': '196',
    'CZ': '203',
    'DK': '208',
    'DM': '212',
    'DO': '214',
    'EC': '218',
    'SV': '222',
    'GQ': '226',
    'ET': '231',
    'ER': '232',
    'EE': '233',
    'FO': '234',
    'FK': '238',
    'GS': '239',
    'FJ': '242',
    'FI': '246',
    'AX': '248',
    'FR': '250',
    'GF': '254',
    'PF': '258',
    'TF': '260',
    'DJ': '262',
    'GA': '266',
    'GE': '268',
    'GM': '270',
    'PS': '275',
    'DE': '276',
    'GH': '288',
    'GI': '292',
    'KI': '296',
    'GR': '300',
    'GL': '304',
    'GD': '308',
    'GP': '312',
    'GU': '316',
    'GT': '320',
    'GN': '324',
    'GY': '328',
    'HT': '332',
    'HM': '334',
    'VA': '336',
    'HN': '340',
    'HK': '344',
    'HU': '348',
    'IS': '352',
    'IN': '356',
    'ID': '360',
    'IR': '364',
    'IQ': '368',
    'IE': '372',
    'IL': '376',
    'IT': '380',
    'CI': '384',
    'JM': '388',
    'JP': '392',
    'KZ': '398',
    'JO': '400',
    'KE': '404',
    'KP': '408',
    'KR': '410',
    'KW': '414',
    'KG': '417',
    'LA': '418',
    'LB': '422',
    'LS': '426',
    'LV': '428',
    'LR': '430',
    'LY': '434',
    'LI': '438',
    'LT': '440',
    'LU': '442',
    'MO': '446',
    'MG': '450',
    'MW': '454',
    'MY': '458',
    'MV': '462',
    'ML': '466',
    'MT': '470',
    'MQ': '474',
    'MR': '478',
    'MU': '480',
    'MX': '484',
    'MC': '492',
    'MN': '496',
    'MD': '498',
    'ME': '499',
    'MS': '500',
    'MA': '504',
    'MZ': '508',
    'OM': '512',
    'NA': '516',
    'NR': '520',
    'NP': '524',
    'NL': '528',
    'CW': '531',
    'AW': '533',
    'SX': '534',
    'BQ': '535',
    'NC': '540',
    'VU': '548',
    'NZ': '554',
    'NI': '558',
    'NE': '562',
    'NG': '566',
    'NU': '570',
    'NF': '574',
    'NO': '578',
    'MP': '580',
    'UM': '581',
    'FM': '583',
    'MH': '584',
    'PW': '585',
    'PK': '586',
    'PA': '591',
    'PG': '598',
    'PY': '600',
    'PE': '604',
    'PH': '608',
    'PN': '612',
    'PL': '616',
    'PT': '620',
    'GW': '624',
    'TL': '626',
    'PR': '630',
    'QA': '634',
    'RE': '638',
    'RO': '642',
    'RU': '643',
    'RW': '646',
    'BL': '652',
    'SH': '654',
    'KN': '659',
    'AI': '660',
    'LC': '662',
    'MF': '663',
    'PM': '666',
    'VC': '670',
    'SM': '674',
    'ST': '678',
    'SA': '682',
    'SN': '686',
    'RS': '688',
    'SC': '690',
    'SL': '694',
    'SG': '702',
    'SK': '703',
    'VN': '704',
    'SI': '705',
    'SO': '706',
    'ZA': '710',
    'ZW': '716',
    'ES': '724',
    'SS': '728',
    'SD': '729',
    'EH': '732',
    'SR': '740',
    'SZ': '748',
    'SE': '752',
    'CH': '756',
    'SY': '760',
    'TJ': '762',
    'TH': '764',
    'TG': '768',
    'TK': '772',
    'TO': '776',
    'TT': '780',
    'AE': '784',
    'TN': '788',
    'TR': '792',
    'TM': '795',
    'TC': '796',
    'TV': '798',
    'UG': '800',
    'UA': '804',
    'MK': '807',
    'EG': '818',
    'GB': '826',
    'GG': '831',
    'JE': '832',
    'IM': '833',
    'TZ': '834',
    'US': '840',
    'VI': '850',
    'BF': '854',
    'UY': '858',
    'UZ': '860',
    'VE': '862',
    'WF': '876',
    'WS': '882',
    'YE': '887',
    'ZM': '894'
}

# Mapping of ISO 4217 currency codes to their number of decimals.
# See https://en.wikipedia.org/wiki/ISO_4217#Minor_unit_fractions.
CURRENCY_MINOR_UNITS = {
    'ADF': 2,
    'ADP': 0,
    'AED': 2,
    'AFA': 2,
    'AFN': 2,
    'ALL': 2,
    'AMD': 2,
    'ANG': 2,
    'AOA': 2,
    'AOK': 0,
    'AON': 0,
    'AOR': 0,
    'ARA': 2,
    'ARL': 2,
    'ARP': 2,
    'ARS': 2,
    'ATS': 2,
    'AUD': 2,
    'AWG': 2,
    'AYM': 0,
    'AZM': 2,
    'AZN': 2,
    'BAD': 2,
    'BAM': 2,
    'BBD': 2,
    'BDS': 2,
    'BDT': 2,
    'BEF': 2,
    'BGL': 2,
    'BGN': 2,
    'BHD': 3,
    'BIF': 0,
    'BMD': 2,
    'BND': 2,
    'BOB': 2,
    'BOP': 2,
    'BOV': 2,
    'BRB': 2,
    'BRC': 2,
    'BRE': 2,
    'BRL': 2,
    'BRN': 2,
    'BRR': 2,
    'BSD': 2,
    'BTN': 2,
    'BWP': 2,
    'BYB': 2,
    'BYN': 2,
    'BYR': 0,
    'BZD': 2,
    'CAD': 2,
    'CDF': 2,
    'CHC': 2,
    'CHE': 2,
    'CHF': 2,
    'CHW': 2,
    'CLF': 4,
    'CLP': 0,
    'CNH': 2,
    'CNT': 2,
    'CNY': 2,
    'COP': 2,
    'COU': 2,
    'CRC': 2,
    'CSD': 2,
    'CUC': 2,
    'CUP': 2,
    'CVE': 2,
    'CYP': 2,
    'CZK': 2,
    'DEM': 2,
    'DJF': 0,
    'DKK': 2,
    'DOP': 2,
    'DZD': 2,
    'ECS': 0,
    'ECV': 2,
    'EEK': 2,
    'EGP': 2,
    'ERN': 2,
    'ESP': 0,
    'ETB': 2,
    'EUR': 2,
    'FIM': 2,
    'FJD': 2,
    'FKP': 2,
    'FRF': 2,
    'GBP': 2,
    'GEK': 0,
    'GEL': 2,
    'GGP': 2,
    'GHC': 2,
    'GHP': 2,
    'GHS': 2,
    'GIP': 2,
    'GMD': 2,
    'GNF': 0,
    'GTQ': 2,
    'GWP': 2,
    'GYD': 2,
    'HKD': 2,
    'HNL': 2,
    'HRD': 2,
    'HRK': 2,
    'HTG': 2,
    'HUF': 2,
    'IDR': 2,
    'IEP': 2,
    'ILR': 2,
    'ILS': 2,
    'IMP': 2,
    'INR': 2,
    'IQD': 3,
    'IRR': 2,
    'ISJ': 2,
    'ISK': 0,
    'ITL': 0,
    'JEP': 2,
    'JMD': 2,
    'JOD': 3,
    'JPY': 0,
    'KES': 2,
    'KGS': 2,
    'KHR': 2,
    'KID': 2,
    'KMF': 0,
    'KPW': 2,
    'KRW': 0,
    'KWD': 3,
    'KYD': 2,
    'KZT': 2,
    'LAK': 2,
    'LBP': 2,
    'LKR': 2,
    'LRD': 2,
    'LSL': 2,
    'LTL': 2,
    'LTT': 2,
    'LUF': 2,
    'LVL': 2,
    'LVR': 2,
    'LYD': 3,
    'MAD': 2,
    'MAF': 2,
    'MCF': 2,
    'MDL': 2,
    'MGA': 2,
    'MGF': 0,
    'MKD': 2,
    'MMK': 2,
    'MNT': 2,
    'MOP': 2,
    'MRO': 2,
    'MRU': 2,
    'MTL': 2,
    'MUR': 2,
    'MVR': 2,
    'MWK': 2,
    'MXN': 2,
    'MXV': 2,
    'MYR': 2,
    'MZE': 2,
    'MZM': 2,
    'MZN': 2,
    'NAD': 2,
    'NGN': 2,
    'NIC': 2,
    'NIO': 2,
    'NIS': 2,
    'NLG': 2,
    'NOK': 2,
    'NPR': 2,
    'NTD': 2,
    'NZD': 2,
    'OMR': 3,
    'PAB': 2,
    'PEN': 2,
    'PES': 2,
    'PGK': 2,
    'PHP': 2,
    'PKR': 2,
    'PLN': 2,
    'PLZ': 2,
    'PRB': 2,
    'PTE': 0,
    'PYG': 0,
    'QAR': 2,
    'RHD': 2,
    'RMB': 2,
    'ROL': 0,
    'RON': 2,
    'RSD': 2,
    'RUB': 2,
    'RUR': 2,
    'RWF': 0,
    'SAR': 2,
    'SBD': 2,
    'SCR': 2,
    'SDD': 2,
    'SDG': 2,
    'SEK': 2,
    'SGD': 2,
    'SHP': 2,
    'SIT': 2,
    'SKK': 2,
    'SLE': 2,
    'SLL': 2,
    'SLS': 2,
    'SML': 0,
    'SOS': 2,
    'SRD': 2,
    'SRG': 2,
    'SSP': 2,
    'STD': 2,
    'STG': 2,
    'STN': 2,
    'SVC': 2,
    'SYP': 2,
    'SZL': 2,
    'THB': 2,
    'TJR': 0,
    'TJS': 2,
    'TMM': 2,
    'TMT': 2,
    'TND': 3,
    'TOP': 2,
    'TPE': 0,
    'TRL': 0,
    'TRY': 2,
    'TTD': 2,
    'TVD': 2,
    'TWD': 2,
    'TZS': 2,
    'UAH': 2,
    'UAK': 2,
    'UGX': 0,
    'USD': 2,
    'USN': 2,
    'USS': 2,
    'UYI': 0,
    'UYN': 2,
    'UYU': 2,
    'UYW': 4,
    'UZS': 2,
    'VAL': 0,
    'VEB': 2,
    'VED': 2,
    'VEF': 2,
    'VES': 2,
    'VND': 0,
    'VUV': 0,
    'WST': 2,
    'XAF': 0,
    'XCD': 2,
    'XEU': 0,
    'XOF': 0,
    'XPF': 0,
    'YER': 2,
    'YUD': 2,
    'YUG': 2,
    'YUM': 2,
    'YUN': 2,
    'YUO': 2,
    'YUR': 2,
    'ZAL': 2,
    'ZAR': 2,
    'ZMK': 2,
    'ZMW': 2,
    'ZRN': 2,
    'ZRZ': 2,
    'ZWB': 2,
    'ZWC': 2,
    'ZWD': 2,
    'ZWL': 2,
    'ZWN': 2,
    'ZWR': 2
}

REPORT_REASONS_MAPPING = {
    'exceed_max_amount': _lt("maximum amount exceeded"),
    'express_checkout_not_supported': _lt("express checkout not supported"),
    'incompatible_country': _lt("incompatible country"),
    'incompatible_currency': _lt("incompatible currency"),
    'incompatible_website': _lt("incompatible website"),
    'manual_capture_not_supported': _lt("manual capture not supported"),
    'provider_not_available': _lt("no supported provider available"),
    'tokenization_not_supported': _lt("tokenization not supported"),
    'validation_not_supported': _lt("tokenization without payment no supported"),
}
