import { _t } from "@web/core/l10n/translation";

export const backgroundShapesDefinition = {
    basic: {
        label: _t("Basic"),
        subgroups: {
            connections: {
                label: _t("Connections"),
                shapes: {
                    "web_editor/Connections/01": { selectLabel: _t("Connections 01") },
                    "web_editor/Connections/02": { selectLabel: _t("Connections 02") },
                    "web_editor/Connections/03": { selectLabel: _t("Connections 03") },
                    "web_editor/Connections/04": { selectLabel: _t("Connections 04") },
                    "web_editor/Connections/05": { selectLabel: _t("Connections 05") },
                    "web_editor/Connections/06": { selectLabel: _t("Connections 06") },
                    "web_editor/Connections/07": { selectLabel: _t("Connections 07") },
                    "web_editor/Connections/08": { selectLabel: _t("Connections 08") },
                    "web_editor/Connections/09": { selectLabel: _t("Connections 09") },
                    "web_editor/Connections/10": { selectLabel: _t("Connections 10") },
                    "web_editor/Connections/11": { selectLabel: _t("Connections 11") },
                    "web_editor/Connections/12": { selectLabel: _t("Connections 12") },
                    "web_editor/Connections/13": { selectLabel: _t("Connections 13") },
                    "web_editor/Connections/14": { selectLabel: _t("Connections 14") },
                    "web_editor/Connections/15": { selectLabel: _t("Connections 15") },
                    "web_editor/Connections/16": { selectLabel: _t("Connections 16") },
                    "web_editor/Connections/17": { selectLabel: _t("Connections 17") },
                    "web_editor/Connections/18": { selectLabel: _t("Connections 18") },
                    "web_editor/Connections/19": { selectLabel: _t("Connections 19") },
                    "web_editor/Connections/20": { selectLabel: _t("Connections 20") },
                },
            },
            containers: {
                label: _t("Containers"),
                shapes: {
                    "web_editor/Containers/01": { selectLabel: _t("Container 01") },
                    "web_editor/Containers/02": { selectLabel: _t("Container 02") },
                    "web_editor/Containers/03": { selectLabel: _t("Container 03") },
                    "web_editor/Containers/04": { selectLabel: _t("Container 04") },
                    "web_editor/Containers/05": { selectLabel: _t("Container 05"), animated: true },
                    "web_editor/Containers/06": { selectLabel: _t("Container 06"), animated: true },
                },
            },
            bold: {
                label: _t("Bold"),
                shapes: {
                    "web_editor/Bold/16": { selectLabel: _t("Bold 01") },
                    "web_editor/Bold/21": { selectLabel: _t("Bold 02") },
                    "web_editor/Bold/17": { selectLabel: _t("Bold 03") },
                    "web_editor/Bold/22": { selectLabel: _t("Bold 04") },
                    "web_editor/Bold/13": { selectLabel: _t("Bold 05") },
                    "web_editor/Bold/14": { selectLabel: _t("Bold 06") },
                    "web_editor/Bold/15": { selectLabel: _t("Bold 07") },
                    "web_editor/Bold/01_001": { selectLabel: _t("Bold 08") },
                    "web_editor/Bold/18": { selectLabel: _t("Bold 09") },
                    "web_editor/Bold/19": { selectLabel: _t("Bold 10") },
                    "web_editor/Bold/23": { selectLabel: _t("Bold 11") },
                    "web_editor/Bold/20": { selectLabel: _t("Bold 12") },
                },
            },
            angular: {
                label: _t("Angular"),
                shapes: {
                    "web_editor/Angular/01": { selectLabel: _t("Angular 01") },
                    "web_editor/Angular/02": { selectLabel: _t("Angular 02") },
                    "web_editor/Angular/03": { selectLabel: _t("Angular 03") },
                    "web_editor/Angular/04": { selectLabel: _t("Angular 04") },
                    "web_editor/Angular/05": { selectLabel: _t("Angular 05") },
                    "web_editor/Angular/06": { selectLabel: _t("Angular 06") },
                    "web_editor/Angular/07": { selectLabel: _t("Angular 07") },
                    "web_editor/Angular/08": { selectLabel: _t("Angular 08") },
                    "web_editor/Angular/09": { selectLabel: _t("Angular 09") },
                    "web_editor/Floats/07": { selectLabel: _t("Angular 10"), animated: true },
                },
            },
            blobs: {
                label: _t("Blobs"),
                shapes: {
                    "web_editor/Blobs/02": { selectLabel: _t("Blob 01") },
                    "web_editor/Blobs/05_001": { selectLabel: _t("Blob 02") },
                    "web_editor/Blobs/03": { selectLabel: _t("Blob 03") },
                    "web_editor/Blobs/06_001": { selectLabel: _t("Blob 04") },
                    "web_editor/Blobs/14": { selectLabel: _t("Blob 05") },
                    "web_editor/Blobs/17": { selectLabel: _t("Blob 06") },
                    "web_editor/Blobs/15": { selectLabel: _t("Blob 07") },
                    "web_editor/Blobs/18": { selectLabel: _t("Blob 08") },
                    "web_editor/Blobs/01_001": { selectLabel: _t("Blob 09"), animated: true },
                    "web_editor/Blobs/16": { selectLabel: _t("Blob 10") },
                    "web_editor/Blobs/04_001": { selectLabel: _t("Blob 11") },
                    "web_editor/Blobs/10_002": { selectLabel: _t("Blob 12") },
                    "web_editor/Blobs/13": { selectLabel: _t("Blob 13") },
                    "web_editor/Floats/03": { selectLabel: _t("Blob 14"), animated: true },
                    "web_editor/Floats/04": { selectLabel: _t("Blob 15"), animated: true },
                    "web_editor/Floats/06": { selectLabel: _t("Blob 16"), animated: true },
                },
            },
        },
    },
    linear: {
        label: _t("Linear"),
        subgroups: {
            airy: {
                label: _t("Airy"),
                shapes: {
                    "web_editor/Airy/01_001": { selectLabel: _t("Airy 01") },
                    "web_editor/Airy/06_001": { selectLabel: _t("Airy 02") },
                    "web_editor/Airy/02_001": { selectLabel: _t("Airy 03") },
                    "web_editor/Airy/07_001": { selectLabel: _t("Airy 04") },
                    "web_editor/Airy/08_001": { selectLabel: _t("Airy 05") },
                    "web_editor/Airy/10_001": { selectLabel: _t("Airy 06") },
                    "web_editor/Airy/09_001": { selectLabel: _t("Airy 07") },
                    "web_editor/Airy/11_001": { selectLabel: _t("Airy 08") },
                    "web_editor/Airy/16": { selectLabel: _t("Airy 09") },
                    "web_editor/Airy/17": { selectLabel: _t("Airy 10") },
                    "web_editor/Airy/12_002": { selectLabel: _t("Airy 11"), animated: true },
                    "web_editor/Airy/13_002": { selectLabel: _t("Airy 12"), animated: true },
                    "web_editor/Airy/14_001": { selectLabel: _t("Airy 13") },
                    "web_editor/Airy/15": { selectLabel: _t("Airy 14"), animated: true },
                },
            },
            grids: {
                label: _t("Grids"),
                shapes: {
                    "web_editor/Grids/01": { selectLabel: _t("Grid 01") },
                    "web_editor/Grids/02": { selectLabel: _t("Grid 02") },
                    "web_editor/Grids/03": { selectLabel: _t("Grid 03") },
                    "web_editor/Grids/04": { selectLabel: _t("Grid 04") },
                    "web_editor/Grids/05": { selectLabel: _t("Grid 05") },
                    "web_editor/Grids/06": { selectLabel: _t("Grid 06") },
                    "web_editor/Grids/07": { selectLabel: _t("Grid 07") },
                    "web_editor/Grids/08": { selectLabel: _t("Grid 08") },
                },
            },
        },
    },
    creative: {
        label: _t("Creative"),
        subgroups: {
            patterns: {
                label: _t("Patterns"),
                shapes: {
                    "web_editor/Patterns/01": { selectLabel: _t("Pattern 01") },
                    "web_editor/Patterns/02": { selectLabel: _t("Pattern 02") },
                    "web_editor/Patterns/03": { selectLabel: _t("Pattern 03") },
                    "web_editor/Patterns/04": { selectLabel: _t("Pattern 04") },
                    "web_editor/Patterns/05": { selectLabel: _t("Pattern 05") },
                    "web_editor/Floats/12": { selectLabel: _t("Pattern 06"), animated: true },
                },
            },
            blurry: {
                label: _t("Blurry"),
                shapes: {
                    "web_editor/Blurry/01": { selectLabel: _t("Blurry 01") },
                    "web_editor/Blurry/02": { selectLabel: _t("Blurry 02") },
                    "web_editor/Blurry/03": { selectLabel: _t("Blurry 03") },
                    "web_editor/Blurry/04": { selectLabel: _t("Blurry 04") },
                    "web_editor/Blurry/05": { selectLabel: _t("Blurry 05") },
                    "web_editor/Blurry/06": { selectLabel: _t("Blurry 06") },
                },
            },

            wavy: {
                label: _t("Wavy"),
                shapes: {
                    "web_editor/Wavy/03": { selectLabel: _t("Wavy 01") },
                    "web_editor/Wavy/10": { selectLabel: _t("Wavy 02") },
                    "web_editor/Wavy/24": { selectLabel: _t("Wavy 03"), animated: true },
                    "web_editor/Wavy/26": { selectLabel: _t("Wavy 04"), animated: true },
                    "web_editor/Wavy/27": { selectLabel: _t("Wavy 05"), animated: true },
                    "web_editor/Wavy/04": { selectLabel: _t("Wavy 06") },
                    "web_editor/Wavy/11_001": { selectLabel: _t("Wavy 07") },
                    "web_editor/Wavy/18": { selectLabel: _t("Wavy 08") },
                    "web_editor/Wavy/08_001": { selectLabel: _t("Wavy 09") },
                    "web_editor/Wavy/09_001": { selectLabel: _t("Wavy 10") },
                    "web_editor/Wavy/22_001": { selectLabel: _t("Wavy 11") },
                    "web_editor/Wavy/29": { selectLabel: _t("Wavy 12") },
                    "web_editor/Wavy/30": { selectLabel: _t("Wavy 13") },
                    "web_editor/Wavy/31": { selectLabel: _t("Wavy 14") },
                },
            },
            blockAndRainy: {
                label: _t("Block & Rainy"),
                shapes: {
                    "web_editor/Blocks/02_001": { selectLabel: _t("Blocks 01") },
                    "web_editor/Rainy/01_001": { selectLabel: _t("Rainy 01"), animated: true },
                    "web_editor/Blocks/01_001": { selectLabel: _t("Blocks 02") },
                    "web_editor/Rainy/02_001": { selectLabel: _t("Rainy 02"), animated: true },
                    "web_editor/Rainy/06": { selectLabel: _t("Rainy 03") },
                    "web_editor/Blocks/04": { selectLabel: _t("Blocks 03") },
                    "web_editor/Rainy/07": { selectLabel: _t("Rainy 04") },
                    "web_editor/Rainy/10": { selectLabel: _t("Rainy 05"), animated: true },
                    "web_editor/Floats/10": { selectLabel: _t("Rainy 06"), animated: true },
                    "web_editor/Floats/11": { selectLabel: _t("Rainy 07"), animated: true },
                    "web_editor/Rainy/08_001": { selectLabel: _t("Rainy 08"), animated: true },
                    "web_editor/Rainy/09_001": { selectLabel: _t("Rainy 09") },
                },
            },
            miscellaneous: {
                label: _t("Miscellaneous"),
                shapes: {
                    "web_editor/Floats/01": { selectLabel: _t("Miscellaneous 01"), animated: true },
                    "web_editor/Floats/02": { selectLabel: _t("Miscellaneous 02"), animated: true },
                    "web_editor/Floats/05": { selectLabel: _t("Miscellaneous 03"), animated: true },
                    "web_editor/Floats/08": { selectLabel: _t("Miscellaneous 04"), animated: true },
                    "web_editor/Floats/09": { selectLabel: _t("Miscellaneous 05"), animated: true },
                    "web_editor/Floats/13": { selectLabel: _t("Miscellaneous 06"), animated: true },
                    "web_editor/Floats/14": { selectLabel: _t("Miscellaneous 07"), animated: true },
                    "web_editor/Zigs/01_001": {
                        selectLabel: _t("Miscellaneous 08"),
                        animated: true,
                    },
                },
            },
        },
    },
};
