import { Component } from "@odoo/owl";
import { Dropdown } from "@web/core/dropdown/dropdown";
import { DropdownItem } from "@web/core/dropdown/dropdown_item";

import { useService } from "@web/core/utils/hooks";

export class ActionList extends Component {
    static components = { Dropdown, DropdownItem };
    static props = ["actions", "inline?", "dropdown?", "odooControlPanelSwitchStyle?", "thread?"];
    static template = "mail.ActionList";

    setup() {
        super.setup();
        this.store = useService("mail.store");
        this.ui = useService("ui");
    }

    get groups() {
        let groups;
        if (this.props.actions.find((i) => Array.isArray(i))) {
            groups = this.props.actions;
        } else {
            groups = [this.props.actions];
        }
        return groups.filter((group) => group.length); // don't show empty groups
    }
}
