# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

from odoo import fields, models, _
from odoo.exceptions import ValidationError


class ResCompany(models.Model):
    _inherit = 'res.company'

    l10n_fr_reference_work_entry_type = fields.Many2one(
        'hr.work.entry.type',
        string='Company Paid Time Off Type')

    def _get_fr_reference_work_entry_type(self):
        self.ensure_one()
        if not self.l10n_fr_reference_work_entry_type:
            raise ValidationError(_("You must first define a reference time off type for the company."))
        return self.l10n_fr_reference_work_entry_type
