import {
    clickOnSave,
    clickOnEditAndWaitEditMode,
    clickOnExtraMenuItem,
    registerWebsitePreviewTour,
    insertSnippet,
} from "@website/js/tours/tour_utils";
import { stepUtils } from "@web_tour/tour_utils";

const EDIT_BUTTON_SELECTOR =
    "body .o_menu_systray button.o-website-btn-custo-primary:contains(edit)";

const checkNoTranslate = {
    content: "Check there is no translate button",
    trigger: `${EDIT_BUTTON_SELECTOR}:not(.o-dropdown-toggle-custo)`,
};
const translate = [
    {
        content: "Open Edit menu",
        trigger: `${EDIT_BUTTON_SELECTOR}.o-dropdown-toggle-custo`,
        run: "click",
    },
    {
        content: "Click on translate button",
        trigger: ".o_popover .o_translate_website_dropdown_item:contains(translate)",
        run: "click",
    },
];
const closeErrorDialog = [
    {
        content: "Check has error dialog",
        trigger: ".modal:contains(error) .o_error_dialog.modal-content",
    },
    {
        content: "Close error dialog",
        trigger: ".modal .modal-footer button.btn.btn-primary",
        run: "click",
    },
    {
        trigger: "body:not(:has(.modal))",
    },
];
const switchTo = (lang) => [
    {
        content: `Switch to ${lang}`,
        trigger: `:iframe .js_change_lang[data-url_code='${lang}']`,
        run: "click",
    },
    {
        content: `Wait until ${lang} is applied`,
        trigger: `:iframe html[lang*="${lang}"]`,
    },
    stepUtils.waitIframeIsReady(),
];
const goToMenuItem = [
    clickOnExtraMenuItem({}, true),
    {
        content: "Navigate to model item page",
        trigger: ":iframe a[href='/test_website/model_item/1']",
        run: "click",
    },
    {
        content: "Wait to land on model item page",
        trigger: ':iframe a[href="/test_website/model_item/1"].nav-link.active:not(:visible)',
    },
    stepUtils.waitIframeIsReady(),
];

registerWebsitePreviewTour(
    "test_restricted_editor_only",
    {
        undeterministicTour_doNotCopy: true,
        url: "/",
    },
    () => [
        // Home
        checkNoTranslate,
        ...clickOnEditAndWaitEditMode(),
        {
            content: "Check icons cannot be dragged",
            trigger: "#snippet_groups .o_snippet[name='Intro'].o_disabled",
            run: function () {
                if (document.querySelector("button.o_snippet_thumbnail_area")) {
                    console.error(
                        "The button to open the add snippet dialog should not be display for restricted editor."
                    );
                }
            },
        },
        ...clickOnSave(),
        ...switchTo("fr"),
        ...translate,
        ...closeErrorDialog,
        ...switchTo("en"),
        // Model item
        {
            trigger: ":iframe body:contains(welcome to your)",
        },
        ...goToMenuItem,
        checkNoTranslate,
        ...clickOnEditAndWaitEditMode(),
        {
            content: "Check icons cannot be dragged",
            trigger: "#snippet_groups .o_snippet[name='Intro'].o_disabled",
            run: function () {
                if (document.querySelector("button.o_snippet_thumbnail_area")) {
                    console.error(
                        "The button to open the add snippet dialog should not be display for restricted editor."
                    );
                }
            },
        },
        ...clickOnSave(),
        ...switchTo("fr"),
        ...translate,
        ...closeErrorDialog,
    ]
);

registerWebsitePreviewTour(
    "test_restricted_editor_test_admin",
    {
        // Remove this key to make the tour fail with error:
        // "Element has not been found." at step "Open Edit menu"
        undeterministicTour_doNotCopy: true,
        url: "/",
    },
    () => [
        // Home
        checkNoTranslate,
        ...clickOnEditAndWaitEditMode(),
        {
            content: "Check icons cannot be dragged",
            trigger: "#snippet_groups .o_snippet[name='Intro'].o_disabled",
        },
        ...clickOnSave(),
        ...switchTo("fr"),
        ...translate,
        ...closeErrorDialog,
        ...switchTo("en"),
        // Model item
        ...goToMenuItem,
        checkNoTranslate,
        ...clickOnEditAndWaitEditMode(),
        {
            content: "Check icons can be dragged",
            trigger: "#snippet_groups .o_snippet[name='Intro']:not(.o_disabled)",
        },
        ...insertSnippet({ id: "s_banner", name: "Banner", groupName: "Intro" }),
        {
            content: "Change name",
            trigger: ":iframe [data-oe-expression='record.name']",
            run: "editor New value",
        },
        ...clickOnSave(),
        ...switchTo("fr"),
        ...translate,
        {
            content: "Close the dialog",
            trigger: ".modal .modal-footer .btn-primary",
            run: "click",
        },
        {
            content: "Assure the modal is well closed",
            trigger: "body:not(:has(.modal))",
        },
        {
            content: "Check that html fields are not content editable when translating",
            trigger:
                ":iframe [data-oe-expression='record.website_description']:not([contenteditable='true'])",
        },
        {
            content: "Translate name",
            trigger: ":iframe [data-oe-expression='record.name']",
            run: "editor Nouvelle valeur",
        },
        {
            content: "Translate some banner text",
            trigger: ":iframe [data-oe-expression='record.website_description'] strong",
            run: "editor potentiel.",
        },
        ...clickOnSave(),
    ]
);

registerWebsitePreviewTour(
    "test_restricted_editor_tester",
    {
        url: "/test_model/1",
    },
    () => [
        ...clickOnEditAndWaitEditMode(),
        {
            content: "Footer should not be be editable for restricted user",
            trigger: ":iframe :has(.o_savable) footer:not(.o_savable):not(:has(.o_savable))",
        },
        ...clickOnSave(),
    ]
);
